# 2020-10-05 Triage Log

A quiet week. One rather large regression on a synthetic benchmark and a few
small improvements.

[#77023](https://github.com/rust-lang/rust/issues/77023) is an interesting
case. It encoded an invariant about slice lengths as an `assume` intrinsic
inside `len` function. It seems to have caused a small compile-time slowdown,
but there was no improvement in `check` build performance (a proxy for generated
code quality). In fact, the LLVM documentation [specifically advises
against](https://llvm.org/docs/LangRef.html#llvm-assume-intrinsic) overuse of
the `assume` intrinsic in cases where the invariant is unlikely to be of much
help to the optimizer. That seems to be the case here.

Triage done by **@ecstaticmorse**.
Revision range: [6369a98ebdee8ce01510f5d4307ddb771c8cb0e5..ea7e131435a960d154e9a5d6a9297039574ffd7d](https://perf.rust-lang.org/?start=6369a98ebdee8ce01510f5d4307ddb771c8cb0e5&end=ea7e131435a960d154e9a5d6a9297039574ffd7d&absolute=false&stat=instructions%3Au)

1 Regressions, 2 Improvements, 1 Mixed

1 of them in rollups

#### Regressions

[#77381](https://github.com/rust-lang/rust/issues/77381) Rollup of 12 pull requests
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=9bb55dc8642d811d66a7599812009cc063577e00&end=b218b952f800c1160b8b5e764ca651b02d678565&stat=instructions:u) (up to 18.3% on `incr-full` builds of `deeply-nested-debug`)
- I suspect [#76909](https://github.com/rust-lang/rust/pull/76909).

#### Improvements

[#77257](https://github.com/rust-lang/rust/issues/77257) Optimize `IntRange::from_pat`, then shrink `ParamEnv`
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=fc2daaae610b5515438b551a2f3706196a997f35&end=48cab6744786cdc5cb5428d2b64efc967ae90496&stat=instructions:u) (up to -2.1% on `full` builds of `ctfe-stress-4-check`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=fc2daaae610b5515438b551a2f3706196a997f35&end=48cab6744786cdc5cb5428d2b64efc967ae90496&stat=instructions:u) (up to 1.3% on `full` builds of `unicode_normalization-check`)

[#77466](https://github.com/rust-lang/rust/issues/77466) Re-land PR #71840 (Rework MIR drop tree lowering) #77466
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=beb5ae474d2835962ebdf7416bd1c9ad864fe101&end=ced813fec0fb9e883906f18b76d618baf9f5bc08&stat=instructions:u) (up to 2.3% on `full` builds of `regex-opt`)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=beb5ae474d2835962ebdf7416bd1c9ad864fe101&end=ced813fec0fb9e883906f18b76d618baf9f5bc08&stat=instructions:u) (up to -2.2% on `incr-unchanged` builds of `webrender-wrench-opt`)

#### Mixed

[#77023](https://github.com/rust-lang/rust/issues/77023) Hint the maximum length permitted by invariant of slices
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=4ccf5f731bb71db3470002d6baf5ab4792b821d9&end=beb5ae474d2835962ebdf7416bd1c9ad864fe101&stat=instructions:u) (up to 2.5% on `incr-patched: sparse set` builds of `regex-opt`)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=4ccf5f731bb71db3470002d6baf5ab4792b821d9&end=beb5ae474d2835962ebdf7416bd1c9ad864fe101&stat=instructions:u) (up to -1.2% on `incr-patched: b9b3e592dd cherry picked` builds of `style-servo-debug`)

#### Nags requiring follow up

- [#77381](https://github.com/rust-lang/rust/issues/77381)
- [#77023](https://github.com/rust-lang/rust/issues/77023)
