# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=icelake-server -instruction-tables < %s | FileCheck %s

aesdec          %xmm0, %xmm2
aesdec          (%rax), %xmm2

aesdeclast      %xmm0, %xmm2
aesdeclast      (%rax), %xmm2

aesenc          %xmm0, %xmm2
aesenc          (%rax), %xmm2

aesenclast      %xmm0, %xmm2
aesenclast      (%rax), %xmm2

aesimc          %xmm0, %xmm2
aesimc          (%rax), %xmm2

aeskeygenassist $22, %xmm0, %xmm2
aeskeygenassist $22, (%rax), %xmm2

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      4     1.00                        aesdec	%xmm0, %xmm2
# CHECK-NEXT:  2      10    1.00    *                   aesdec	(%rax), %xmm2
# CHECK-NEXT:  1      4     1.00                        aesdeclast	%xmm0, %xmm2
# CHECK-NEXT:  2      10    1.00    *                   aesdeclast	(%rax), %xmm2
# CHECK-NEXT:  1      4     1.00                        aesenc	%xmm0, %xmm2
# CHECK-NEXT:  2      10    1.00    *                   aesenc	(%rax), %xmm2
# CHECK-NEXT:  1      4     1.00                        aesenclast	%xmm0, %xmm2
# CHECK-NEXT:  2      10    1.00    *                   aesenclast	(%rax), %xmm2
# CHECK-NEXT:  2      8     2.00                        aesimc	%xmm0, %xmm2
# CHECK-NEXT:  3      14    2.00    *                   aesimc	(%rax), %xmm2
# CHECK-NEXT:  11     20    6.00                        aeskeygenassist	$22, %xmm0, %xmm2
# CHECK-NEXT:  11     25    6.00    *                   aeskeygenassist	$22, (%rax), %xmm2

# CHECK:      Resources:
# CHECK-NEXT: [0]   - ICXDivider
# CHECK-NEXT: [1]   - ICXFPDivider
# CHECK-NEXT: [2]   - ICXPort0
# CHECK-NEXT: [3]   - ICXPort1
# CHECK-NEXT: [4]   - ICXPort2
# CHECK-NEXT: [5]   - ICXPort3
# CHECK-NEXT: [6]   - ICXPort4
# CHECK-NEXT: [7]   - ICXPort5
# CHECK-NEXT: [8]   - ICXPort6
# CHECK-NEXT: [9]   - ICXPort7
# CHECK-NEXT: [10]  - ICXPort8
# CHECK-NEXT: [11]  - ICXPort9

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]
# CHECK-NEXT:  -      -     19.00  1.00   3.00   3.00    -     13.00   -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   Instructions:
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -      -      -      -     aesdec	%xmm0, %xmm2
# CHECK-NEXT:  -      -     1.00    -     0.50   0.50    -      -      -      -      -      -     aesdec	(%rax), %xmm2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -      -      -      -     aesdeclast	%xmm0, %xmm2
# CHECK-NEXT:  -      -     1.00    -     0.50   0.50    -      -      -      -      -      -     aesdeclast	(%rax), %xmm2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -      -      -      -     aesenc	%xmm0, %xmm2
# CHECK-NEXT:  -      -     1.00    -     0.50   0.50    -      -      -      -      -      -     aesenc	(%rax), %xmm2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -      -      -      -     aesenclast	%xmm0, %xmm2
# CHECK-NEXT:  -      -     1.00    -     0.50   0.50    -      -      -      -      -      -     aesenclast	(%rax), %xmm2
# CHECK-NEXT:  -      -     2.00    -      -      -      -      -      -      -      -      -     aesimc	%xmm0, %xmm2
# CHECK-NEXT:  -      -     2.00    -     0.50   0.50    -      -      -      -      -      -     aesimc	(%rax), %xmm2
# CHECK-NEXT:  -      -     3.67   0.67    -      -      -     6.67    -      -      -      -     aeskeygenassist	$22, %xmm0, %xmm2
# CHECK-NEXT:  -      -     3.33   0.33   0.50   0.50    -     6.33    -      -      -      -     aeskeygenassist	$22, (%rax), %xmm2
